<?php
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: bk_mysql.inc,v 1.1 2000/04/10 17:42:06 prenagha Exp $
# ---------------------------------------------------------------
# database specific callout functions for
# MySQL database.

class bk_db_callout_class {

# what is the offset of the first row for the db you are using?
  var $db_first_row_offset = 0;


# build the SQL that will set the added date of the bookmark.
# Something must be returned for the INSERT to work.
  function get_current_date_sql () {
    return "CURDATE()";
  }


# if you want to change the sql generated by the PHPLIB 
# sqlquery class before it is sent to the database, you
# can do that here. if not, just return the var passed in.
# the returned string is sent to the database.
  function fix_search_sql ($query) {
    return $query;
  }


# set big tables option so that temp tables are written to
# disk for this query. this prevents the table out of memory
# error on the list page.
# Return TRUE if your db doesn't support this feature.
  function set_big_temp_tables ($db) {
    $query = "SET OPTION SQL_BIG_TABLES=1";

    $db->query($query);
    if ($db->Errno != 0) return FALSE;

    return TRUE;
  }


# build the limit sql claused used by the list page to
# print n bookmarks per page.
# Return " " if your db doesn't support this feature.
  function get_limit_sql ($offset, $limit) {
    if ($limit > 0) {
      $limit_sql = sprintf(" limit %s,%s", $offset, $limit);
    } else {
      $limit_sql = " ";
    }
    return $limit_sql;
  }

# class constructor
  function bk_db_callout_class () {
  }
}
?>
